//=============================================================================
// AmmoShell.
//=============================================================================
class AmmoShotgun extends DeusExAmmo;

#exec MESH IMPORT MESH=ShotgunAmmo ANIVFILE=MODELS\ShotgunAmmo_a.3d DATAFILE=MODELS\ShotgunAmmo_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=ShotgunAmmo X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=0

#exec MESH SEQUENCE MESH=ShotgunAmmo SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=ShotgunAmmo SEQ=ShotgunAmmo STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=ShotgunAmmo MESH=ShotgunAmmo
#exec MESHMAP SCALE MESHMAP=ShotgunAmmo X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\SAGray.pcx"	NAME="ShotAGray"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\SARed.pcx"	NAME="ShotARed"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\SAGold.pcx"	NAME="ShotAGold"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\SAOrange.pcx"	NAME="ShotAOrange"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=ShotgunAmmo NUM=0 TEXTURE=ShotAOrange
#exec MESHMAP SETTEXTURE MESHMAP=ShotgunAmmo NUM=1 TEXTURE=ShotARed
#exec MESHMAP SETTEXTURE MESHMAP=ShotgunAmmo NUM=2 TEXTURE=ShotAGold
#exec MESHMAP SETTEXTURE MESHMAP=ShotgunAmmo NUM=3 TEXTURE=ShotAGray


//
// SimUseAmmo - Spawns shell casings client side
//
simulated function bool SimUseAmmo()
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing2 shell;

	if ( AmmoAmount > 0 )
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;

		shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
		shell.RemoteRole = ROLE_None;

		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

function bool UseAmmo(int AmountNeeded)
{
	local vector offset, tempvec, X, Y, Z;
	local ShellCasing2 shell;

	if (Super.UseAmmo(AmountNeeded))
	{
		GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
		offset = Owner.CollisionRadius * X + 0.3 * Owner.CollisionRadius * Y;
		tempvec = 0.8 * Owner.CollisionHeight * Z;
		offset.Z += tempvec.Z;
      if ( DeusExMPGame(Level.Game) != None )
      {
			if ( Level.NetMode == NM_ListenServer )
			{
	         shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
				shell.RemoteRole = ROLE_None;
			}
			else
	         shell = None;
      }
      else
      {
         shell = spawn(class'ShellCasing2',,, Owner.Location + offset);
      }
		if (shell != None)
		{
			shell.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
			shell.Velocity.Z = 0;
		}
		return True;
	}
	return False;
}

defaultproperties
{
     bShowInfo=True
     AmmoAmount=8
     MaxAmmo=120
     ItemName="Shotgun Shells"
     ItemArticle="some"
     PickupViewMesh=LodMesh'ShotgunAmmo'
     Icon=Texture'DeusExUI.Icons.BeltIconAmmoShells'
     largeIcon=Texture'DeusExUI.Icons.LargeIconAmmoShells'
     largeIconWidth=0
     largeIconHeight=0
     Description=""
     beltDescription=""
     Mesh=LodMesh'ShotgunAmmo'
     CollisionRadius=4.450000
     CollisionHeight=1.000000
     bCollideActors=True
}
